#include "DataBall.h"

namespace DataTypes
{

DataBall::DataBall()
{
}

DataBall::DataBall(int entityid, int materialid, float mass,Vector3f position, float radius, Vector3f rotation, Vector3f linearvelocity, Vector3f angularvelocity):DataEntity(entityid)
{
		this->radius = radius;
		this->position = position;
		this->rotation = rotation;
		this->materialid = materialid;
		this->mass = mass;
		this->linearvelocity = linearvelocity;
		this->angularvelocity = angularvelocity;
}

DataBall::~DataBall()
{
}

float DataBall::GetRadius()
{
	return radius;
}

Vector3f DataBall::GetPosition()
{
	return position;
}

Vector3f DataBall::GetRotation()
{
	return rotation;
}

int DataBall::GetMaterialId()
{
	return materialid;
}

float DataBall::GetMass()
{
	return mass;
}

Vector3f DataBall::GetLinearVelocity()
{
	return this->linearvelocity;
}

Vector3f DataBall::GetAngularVelocity()
{
	return this->angularvelocity;
}



void DataBall::SetMass(float value)
{
	this->mass = value;
}

void DataBall::SetRadius(float value)
{
	this->radius = value;
}

void DataBall::SetPosition(Vector3f value)
{
	this->position = value;
}

void DataBall::SetRotation(Vector3f value)
{
	this->rotation = value;
}

void DataBall::SetMateriaId(int value)
{
	this->materialid = value;
}

}
